/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.filesvr;

import com.ibm.hsc.filesvr.FsException;
import java.io.File;
import java.text.DateFormat;
import java.util.Date;
import java.util.GregorianCalendar;

public class FsFileDescriptor {
    private File m_file = null;
    private String m_name = null;
    private long m_size = 0L;
    private GregorianCalendar m_date = null;

    public FsFileDescriptor(File file) {
        if (file == null) {
            throw new NullPointerException();
        }
        this.setFile(file);
    }

    public FsFileDescriptor(String string) throws FsException {
        this.setName(string);
    }

    public FsFileDescriptor(String string, long l) throws FsException {
        this.setName(string);
        this.m_size = l;
    }

    public FsFileDescriptor(String string, long l, GregorianCalendar gregorianCalendar) throws FsException {
        this.setName(string);
        this.m_size = l;
        this.m_date = gregorianCalendar;
    }

    public GregorianCalendar getDate() {
        return this.m_date;
    }

    public int getDateDay() {
        return this.m_date.get(5);
    }

    public int getDateHour() {
        return this.m_date.get(11);
    }

    public int getDateMinute() {
        return this.m_date.get(12);
    }

    public int getDateMonth() {
        return this.m_date.get(2) + 1;
    }

    public int getDateSecond() {
        return this.m_date.get(13);
    }

    public String getDateString() {
        if (this.m_date != null) {
            return DateFormat.getDateTimeInstance(3, 2).format(this.m_date.getTime());
        }
        return null;
    }

    public int getDateYear() {
        return this.m_date.get(1);
    }

    public File getFile() {
        return this.m_file;
    }

    public String getName() {
        return this.m_name;
    }

    public long getSize() {
        return this.m_size;
    }

    public long getTime() {
        if (this.m_date != null) {
            return this.m_date.getTime().getTime();
        }
        return 0L;
    }

    public void setFile(File file) {
        this.m_file = file;
        if (file != null) {
            this.setName(file.getName());
            this.m_size = file.length();
            this.m_date = new GregorianCalendar();
            this.m_date.setTime(new Date(file.lastModified()));
        }
    }

    public void setName(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        this.m_name = string;
    }
}

